﻿Imports System.Text
Imports System.Management

Public Class Frm_ProcessChk

    Private Sub Btn_Application_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_Application.Click
        Dim StrBlder As New StringBuilder()
        Dim pProc As New Process()

        For Each pProc In Process.GetProcesses(".")
            If pProc.MainWindowTitle.Length > 0 Then
                StrBlder.Append("Window Title:  " + pProc.MainWindowTitle.ToString() + Environment.NewLine)
                StrBlder.Append("Process Name:  " + pProc.ProcessName.ToString() + Environment.NewLine)
                StrBlder.Append("Window Handle:  " + pProc.MainWindowHandle.ToString() + Environment.NewLine)
                StrBlder.Append("Memory Allocation: " + pProc.PrivateMemorySize64.ToString() + Environment.NewLine)
                StrBlder.Append(Environment.NewLine)
            End If
        Next
        Txt_ListProcess.Text = StrBlder.ToString
    End Sub

    Private Sub Btn_Exit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_Exit.Click
        End
    End Sub

    Private Sub Btn_Process_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_Process.Click

        Dim Str_Bld As New StringBuilder()
        Dim MgtClass As New ManagementClass("Win32_Process")
        Dim MgtObj As New ManagementObject()

        For Each MgtObj In MgtClass.GetInstances

            Str_Bld.Append("Name:  " & MgtObj("Name") & Environment.NewLine)
            Str_Bld.Append("ID:  " & MgtObj("ProcessId") & Environment.NewLine)
            Str_Bld.Append(Environment.NewLine)

        Next

        Txt_ListProcess.Text = Str_Bld.ToString
    End Sub

    Private Sub Btn_App_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_App.Click
        Dim Bol_Proc As Boolean = False
        Dim Proc As New Process()
        Dim AppName As String = Trim(Txt_Application.Text)

        For Each Proc In Process.GetProcesses(".")
            If Proc.ProcessName.ToLower() = AppName.ToLower() Then
                Bol_Proc = True
            End If
        Next

        If Bol_Proc = True Then
            MessageBox.Show(Txt_Application.Text + " process name found.", "CADCIM Technologies")
        Else
            MessageBox.Show(Txt_Application.Text + " process name not found.", "CADCIM Technologies")
        End If
    End Sub

    Private Sub Btn_Proc_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_Proc.Click

        Dim MgtClass As New ManagementClass("Win32_Process")
        Dim MgtObj As New ManagementObject()

        Dim Bol_Proc As Boolean = False
        Dim Str_Proc As String = Trim(Txt_Process.Text)

        For Each MgtObj In MgtClass.GetInstances()
            If MgtObj("Name").ToString().ToLower() = Str_Proc.ToLower() Then
                Bol_Proc = True
            End If
        Next

        If Bol_Proc = True Then
            MessageBox.Show(Txt_Process.Text & " process name found.", "CADCIM Technologies")
        Else
            MessageBox.Show(Txt_Process.Text & " process name not found.", "CADCIM Technologies")
        End If

    End Sub

   
    
    Private Sub GroupBox1_Enter(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles GroupBox1.Enter

    End Sub
End Class