﻿Imports System.Drawing
Imports System.IO
Imports System.IO.File
Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Drawing.Imaging
Imports System.Text
Imports System.Windows.Forms
Imports ExtendedRichTextBox

Public Class FrmMain

    'Dim Copy_string As String
    Dim Bol_True As Boolean
    'Dim Del_text As String
    Dim Bol_WordWarp As Boolean
    Private currentFile As String
    Private checkPrint As Integer

    Private Sub FrmMain_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If Rftbox.Modified = True Then
            Dim Ans As DialogResult
            Ans = MessageBox.Show("Save current document before exit?", "Unsaved Document", MessageBoxButtons.YesNo, MessageBoxIcon.Question)

            If Ans = System.Windows.Forms.DialogResult.No Then
                Rftbox.Modified = False
                Rftbox.Clear()
                Return
            Else
                SaveMenuItem_Click(Me, New EventArgs())
            End If
        Else
            Rftbox.Clear()
            currentFile = ""
            Me.Text = "CADCIM: New Document"
        End If

    End Sub

    Private Sub FrmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim RichTextbox As New ExtendedRichTextBox.RichTextBoxPrintCtrl

        RichTextbox.Name = "Rftbox"
        RichTextbox.Dock = DockStyle.Fill
        RichTextbox.Location = New Size(0, 50)
        Me.Controls.Add(RichTextbox)

        ContextMenuStrip1.Visible = True
        ContextMenuStrip1.Enabled = False
        FindPanel.Visible = False
        Me.ReplacePanel.Visible = False
        Bol_True = True
        Bol_WordWarp = False
        'GrpFind.Visible = False
        Btn_FindNext.Enabled = False
        Btn_RF_Next.Enabled = False

    End Sub

    Private Sub Form1_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Resize
        Rftbox.Width = Me.Width - 10
        Rftbox.Height = Me.Height - 80
    End Sub

    Private Sub Rftbox_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs)
        If Not Rftbox.Text = "" Then
            ContextMenuStrip1.Enabled = True
        End If
    End Sub

    Private Sub UndoContextToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles UndoContextToolStripMenuItem.Click
        Rftbox.Undo()
    End Sub

    Private Sub SelectAllContextToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SelectAllContextToolStripMenuItem.Click
        Rftbox.SelectAll()
    End Sub

    Private Sub Rftbox_TextChanged_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Rftbox.TextChanged
        If Rftbox.Text <> "" Then
            ContextMenuStrip1.Enabled = True
        Else
            ContextMenuStrip1.Enabled = False
        End If
    End Sub

    Private Sub NewMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NewMenuItem.Click
        If Rftbox.Modified = True Then
            Dim Ans As DialogResult
            Ans = MessageBox.Show("Save current document before creating new document?", "Unsaved Document", MessageBoxButtons.YesNo, MessageBoxIcon.Question)

            If Ans = Windows.Forms.DialogResult.No Then
                currentFile = ""
                Me.Text = "CADCIM - New Document"
                Rftbox.Modified = False
                Rftbox.Clear()
            Else
                SaveMenuItem_Click(Me, New EventArgs)
                Me.Text = "CADCIM - New Document"
                Rftbox.Modified = False
                Rftbox.Clear()
                Return
            End If
        Else
            currentFile = ""
            Me.Text = "CADCIM - New Document"
            Rftbox.Modified = False
            Rftbox.Clear()
            Return
        End If
    End Sub
    Public Sub OpenFile()
        OpenFileDialog1.Title = "CADCIM - Open File"
        OpenFileDialog1.DefaultExt = "rtf"
        OpenFileDialog1.Filter = "Rich Text Files|*.rtf|Text Files|*.txt|HTML Files|*.htm|All Files|*.*"
        OpenFileDialog1.FilterIndex = 1
        OpenFileDialog1.FileName = String.Empty

        If OpenFileDialog1.ShowDialog = Windows.Forms.DialogResult.OK Then
            If OpenFileDialog1.FileName = "" Then
                Exit Sub
            End If
            Dim StrExt As String
            StrExt = Path.GetExtension(OpenFileDialog1.FileName)
            StrExt = StrExt.ToUpper
            If StrExt = ".RTF" Then
                Rftbox.LoadFile(OpenFileDialog1.FileName, RichTextBoxStreamType.RichText)
            Else
                Dim Str_cont As String
                Dim oRead As System.IO.StreamReader
                oRead = OpenText(OpenFileDialog1.FileName)
                Str_cont = ""

                Do While oRead.Peek <> -1
                    Str_cont = Str_cont & oRead.ReadLine
                    Str_cont = Str_cont & Chr(13)
                Loop
                Rftbox.Text = Str_cont
                currentFile = OpenFileDialog1.FileName

                Me.Text = "CADCIM - " & currentFile
                oRead.Close()
            End If
        Else
            MessageBox.Show("Open File request cancelled by user.", "Cancelled")
        End If

    End Sub

    Private Sub OpenMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OpenMenuItem.Click
        If Rftbox.Modified = True Then
            Dim Ans As DialogResult
            Ans = MessageBox.Show("Save current document before creating new document?", "Unsaved Document", MessageBoxButtons.YesNo, MessageBoxIcon.Question)

            If Ans = Windows.Forms.DialogResult.No Then
                Rftbox.Modified = False
                OpenFile()
            Else
                SaveMenuItem_Click(Me, New EventArgs)
            End If
        Else
            OpenFile()
        End If
    End Sub

    Private Sub SaveMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SaveMenuItem.Click
        Try
            If currentFile = String.Empty Then
                SaveAsMenuItem_Click(Me, New EventArgs)
                Exit Sub
            End If

            Dim StrExt As String
            StrExt = Path.GetExtension(currentFile)

            If StrExt = ".RFT" Then
                Rftbox.SaveFile(currentFile)
            Else
                Dim oWrite As IO.StreamWriter
                oWrite = CreateText(currentFile)
                oWrite.Write(Rftbox.Text)
                oWrite.Close()
                oWrite = Nothing
                Rftbox.SelectionStart = 0
                Rftbox.SelectionLength = 0
            End If

            Me.Text = "CADCIM - " & currentFile
            Rftbox.Modified = False

        Catch ex As Exception
            MessageBox.Show(ex.Message.ToString(), "Error-CADCIM")
        End Try
    End Sub

    Private Sub SaveAsMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SaveAsMenuItem.Click
        Try
            SaveFileDialog1.Title = "CADCIM - Save File"
            SaveFileDialog1.DefaultExt = "rtf"
            SaveFileDialog1.Filter = "Rich Text Files|*.rtf|Text Files|*.txt|HTML Files|*.htm|All Files|*.*"
            SaveFileDialog1.FilterIndex = 1

            If SaveFileDialog1.ShowDialog() = Windows.Forms.DialogResult.OK Then
                If SaveFileDialog1.FileName = "" Then
                    Exit Sub
                End If

                Dim StrExt As String
                Dim Filename As String
                StrExt = Path.GetExtension(SaveFileDialog1.FileName)
                StrExt = StrExt.ToUpper

                If StrExt = ".RTF" Then
                    Rftbox.SaveFile(SaveFileDialog1.FileName, RichTextBoxStreamType.RichText)
                Else
                    Dim oWrite As IO.StreamWriter

                    oWrite = New IO.StreamWriter(SaveFileDialog1.FileName)
                    oWrite.Write(Rftbox.Text)
                    oWrite.Close()
                    oWrite = Nothing

                    Rftbox.SelectionStart = 0
                    Rftbox.SelectionLength = 0
                End If
                currentFile = SaveFileDialog1.FileName
                Rftbox.Modified = False
                Filename = Mid(currentFile, currentFile.LastIndexOf("\") + 2)
                Me.Text = "CADCIM - " + Filename
                MessageBox.Show(currentFile.ToString() + " saved.", "File Save")
            Else
                MessageBox.Show("Save File request cancelled by user...", "Cancelled")
            End If

        Catch ex As Exception

            MessageBox.Show(ex.Message.ToString(), "Error-CADCIM")
        End Try
    End Sub


    Private Sub BoldMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BoldMenuItem.Click
        If Not Rftbox.SelectedText = "" Then
            Dim CurrentFont As Font = Rftbox.SelectionFont
            Dim newFontStyle As FontStyle

            If Rftbox.SelectionFont.Style = FontStyle.Bold Then
                newFontStyle = FontStyle.Regular
            Else
                newFontStyle = FontStyle.Bold Or Rftbox.SelectionFont.Style
            End If

            Rftbox.SelectionFont = New Font(CurrentFont.FontFamily, CurrentFont.Size, newFontStyle)
        End If

    End Sub

    Private Sub ItalicMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ItalicMenuItem.Click
        If Not Rftbox.SelectedText = "" Then
            Dim CurrentFont As Font = Rftbox.SelectionFont
            Dim newFontStyle As FontStyle

            If Rftbox.SelectionFont.Style = FontStyle.Italic Then
                newFontStyle = FontStyle.Regular
            Else
                newFontStyle = FontStyle.Italic Or Rftbox.SelectionFont.Style
            End If
            Rftbox.SelectionFont = New Font(CurrentFont.FontFamily, CurrentFont.Size, newFontStyle)
        End If

    End Sub

    Private Sub UnderlineMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles UnderlineMenuItem.Click
        If Not Rftbox.SelectedText = "" Then
            Dim CurrentFont As Font = Rftbox.SelectionFont
            Dim newFontStyle As FontStyle

            If Rftbox.SelectionFont.Style = FontStyle.Underline Then
                newFontStyle = FontStyle.Regular
            Else
                newFontStyle = FontStyle.Underline Or Rftbox.SelectionFont.Style
            End If

            Rftbox.SelectionFont = New Font(CurrentFont.FontFamily, CurrentFont.Size, newFontStyle)
        End If

    End Sub

    Private Sub NormalMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NormalMenuItem.Click
        If Not Rftbox.SelectedText = "" Then
            Dim CurrentFont As Font = Rftbox.SelectionFont
            Dim newFontStyle As FontStyle

            newFontStyle = FontStyle.Regular
            Rftbox.SelectionFont = New Font(CurrentFont.FontFamily, CurrentFont.Size, newFontStyle)
        End If

    End Sub

    Private Sub PageColorMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PageColorMenuItem.Click
        ColorDialog1.Color = Rftbox.BackColor

        If ColorDialog1.ShowDialog = Windows.Forms.DialogResult.OK Then
            Rftbox.BackColor = ColorDialog1.Color
        End If
    End Sub

    Private Sub FontColorMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FontColorMenuItem.Click
        If ColorDialog1.ShowDialog = Windows.Forms.DialogResult.OK Then
            If ColorDialog1.Color = Rftbox.SelectionColor Then Exit Sub
            'ShowDialog method makes the dialog box visible at runtime.
            Rftbox.SelectionColor = ColorDialog1.Color
            'Forecolor method of the RichTextBox set the color to the text contain in it.
        End If
    End Sub

    Private Sub tbrBold_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbrBold.Click
        BoldMenuItem_Click(Me, New EventArgs)
    End Sub

    Private Sub tbrItalic_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbrItalic.Click
        ItalicMenuItem_Click(Me, New EventArgs)
    End Sub

    Private Sub tbrUnderline_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbrUnderline.Click
        UnderlineMenuItem_Click(Me, New EventArgs)
    End Sub

    Private Sub LeftToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LeftToolStripMenuItem.Click
        Rftbox.SelectionAlignment = HorizontalAlignment.Left
    End Sub

    Private Sub CenterToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CenterToolStripMenuItem.Click
        Rftbox.SelectionAlignment = HorizontalAlignment.Center
    End Sub

    Private Sub RightToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RightToolStripMenuItem.Click
        Rftbox.SelectionAlignment = HorizontalAlignment.Right
    End Sub

    Private Sub tbrLeft_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbrLeft.Click
        LeftToolStripMenuItem_Click(Me, New EventArgs)
    End Sub

    Private Sub tbrCenter_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbrCenter.Click
        CenterToolStripMenuItem_Click(Me, New EventArgs)
    End Sub

    Private Sub tbrRight_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbrRight.Click
        RightToolStripMenuItem_Click(Me, New EventArgs)
    End Sub

    Private Sub PageSetupMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PageSetupMenuItem.Click
        PageSetupDialog1.Document = PrintDocument1
        PageSetupDialog1.ShowDialog()
    End Sub

    Private Sub ExitMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitMenuItem.Click
        End
    End Sub

    Private Sub PrintDocument1_BeginPrint(ByVal sender As Object, ByVal e As System.Drawing.Printing.PrintEventArgs) Handles PrintDocument1.BeginPrint
        checkPrint = 0
    End Sub

    Private Sub PrintDocument1_PrintPage(ByVal sender As Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs) Handles PrintDocument1.PrintPage
        checkPrint = Rftbox.Print(checkPrint, Rftbox.TextLength, e)

        If checkPrint < Rftbox.TextLength Then
            e.HasMorePages = True
        Else
            e.HasMorePages = False
        End If

    End Sub

    Private Sub UndoMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles UndoMenuItem.Click
        If Rftbox.CanUndo Then
            Rftbox.Undo()
        End If
    End Sub

    Private Sub RedoMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RedoMenuItem.Click
        If Rftbox.CanRedo Then
            Rftbox.Redo()
        End If
    End Sub

    Private Sub tspColor_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tspColor.Click
        FontColorMenuItem_Click(Me, New EventArgs)
    End Sub
    Private Sub FindAndReplaceMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FindAndReplaceMenuItem.Click
        'Dim Frm As FrmReplace = New FrmReplace

        If FindPanel.Visible = True Then
            FindPanel.Visible = False
            Me.ReplacePanel.Visible = True
            Txt_search.Text = TxtFind.Text
            Txt_Replace.Focus()
        Else
            Me.ReplacePanel.Visible = True
            Txt_search.Focus()
        End If
    End Sub

    Private Sub tbrFind_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbrFind.Click
        FindAndReplaceMenuItem_Click(Me, New EventArgs)
    End Sub

    Private Sub FindMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FindMenuItem.Click
        FindPanel.Visible = True
        TxtFind.Focus()
    End Sub

    Private Sub PreviewMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PreviewMenuItem.Click
        PrintPreviewDialog1.Document = PrintDocument1
        PrintPreviewDialog1.ShowDialog()
    End Sub

    Private Sub PrintMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PrintMenuItem.Click
        PrintDialog1.Document = PrintDocument1
        If PrintDialog1.ShowDialog() = System.Windows.Forms.DialogResult.OK Then
            PrintDocument1.Print()
        End If
    End Sub

    Private Sub InsertImageMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles InsertImageMenuItem.Click
        Try
            OpenFileDialog1.Title = "CADCIM - Insert Image File"
            OpenFileDialog1.DefaultExt = "rtf"
            OpenFileDialog1.Filter = "Bitmap Files|*.bmp|JPEG Files|*.jpg|GIF Files|*.gif"
            OpenFileDialog1.FilterIndex = 1
            OpenFileDialog1.ShowDialog()

            If OpenFileDialog1.FileName = "" Then
                Exit Sub
            End If

            Dim StrImagePath As String = OpenFileDialog1.FileName
            Dim Img As Image
            Dim Df As DataFormats.Format

            Img = Image.FromFile(StrImagePath)
            Clipboard.SetDataObject(Img)
            Df = DataFormats.GetFormat(DataFormats.Bitmap)

            If Me.Rftbox.CanPaste(Df) Then
                Me.Rftbox.Paste(Df)
            Else
                MessageBox.Show("Can not insert the image", "CADCIM")
            End If

        Catch ex As Exception
            MessageBox.Show(ex.Message.ToString(), "Error-CADCIM")
        End Try
    End Sub

    Private Sub SelectAllMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SelectAllMenuItem.Click
        Rftbox.SelectAll()
    End Sub

    Private Sub CopyMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles CopyMenuItem.Click
        Rftbox.Copy()
    End Sub

    Private Sub CutMenuItem_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles CutMenuItem.Click
        Rftbox.Cut()
    End Sub

    Private Sub PasteMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PasteMenuItem.Click
        Rftbox.Paste()
    End Sub

    Private Sub NoneIndentMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NoneIndentMenuItem.Click
        Rftbox.SelectionIndent = 0
    End Sub

    Private Sub Indent5MenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Indent5MenuItem.Click
        Rftbox.SelectionIndent = 5
    End Sub

    Private Sub Indent10MenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Indent10MenuItem.Click
        Rftbox.SelectionIndent = 10
    End Sub

    Private Sub Indent15MenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Indent15MenuItem.Click
        Rftbox.SelectionIndent = 15
    End Sub

    Private Sub Indent20MenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Indent20MenuItem.Click
        Rftbox.SelectionIndent = 20
    End Sub


    Private Sub AddBulletsMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AddBulletsMenuItem.Click
        Rftbox.SelectionIndent = 10
        Rftbox.SelectionBullet = True
    End Sub

    Private Sub RemoveBulletsMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RemoveBulletsMenuItem.Click
        Rftbox.SelectionIndent = 0
        Rftbox.SelectionBullet = False
    End Sub

    Private Sub ToolStripMenuItem3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripMenuItem3.Click
        Rftbox.Cut()
    End Sub

    Private Sub ToolStripMenuItem2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripMenuItem2.Click
        Rftbox.Paste()
    End Sub

    Private Sub tbrSave_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbrSave.Click
        SaveMenuItem_Click(Me, New EventArgs)
    End Sub

    Private Sub tbrNew_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbrNew.Click
        NewMenuItem_Click(Me, New EventArgs)
    End Sub

    Private Sub SelectFontMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SelectFontMenuItem.Click
        Try
            If Rftbox.SelectionFont.Name = "" Then
                FontDialog1.Font = Rftbox.SelectionFont
            Else
                FontDialog1.Font = Nothing
            End If

            FontDialog1.ShowApply = True
            If FontDialog1.ShowDialog = System.Windows.Forms.DialogResult.OK Then
                Rftbox.SelectionFont = FontDialog1.Font
            End If

        Catch ex As Exception
            MessageBox.Show(ex.Message.ToString(), "Error-CADCIM")
        End Try
    End Sub

    Private Sub tbrFont_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbrFont.Click
        SelectFontMenuItem_Click(Me, New EventArgs)
    End Sub

    Private Sub Btn_Find_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_Find.Click
        Try
            If Trim(Rftbox.Text) = "" Then Exit Sub
            Dim StartPosition As Integer
            Dim SearchType As StringComparison

            If ChkMatchCase.Checked = True Then
                SearchType = StringComparison.Ordinal
            Else
                SearchType = StringComparison.OrdinalIgnoreCase
            End If

            StartPosition = Rftbox.Text.IndexOf(TxtFind.Text, SearchType)

            If StartPosition = 0 Then
                MessageBox.Show("String: " + TxtFind.Text.ToString() + " not found", "No Matches", MessageBoxButtons.OK, MessageBoxIcon.Asterisk)
                Exit Sub
            End If

            Rftbox.Select(StartPosition, TxtFind.TextLength)
            Rftbox.ScrollToCaret()
            Rftbox.Focus()
            Btn_FindNext.Enabled = True

        Catch ex As Exception
            MessageBox.Show(ex.Message.ToString(), "Error-CADCIM")
        End Try
    End Sub

    Private Sub Btn_FindNext_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_FindNext.Click
        Try
            If Trim(Rftbox.Text) = "" Then Exit Sub
            Dim StartPosition As Integer = Rftbox.SelectionStart + 2
            Dim SearchType As StringComparison

            If ChkMatchCase.Checked = True Then
                SearchType = StringComparison.Ordinal
            Else
                SearchType = StringComparison.OrdinalIgnoreCase
            End If

            'StartPosition = Microsoft.VisualBasic.Strings.InStr(StartPosition, mMain.Rftbox.Text, txtSearchTerm.Text, SearchType);
            StartPosition = Rftbox.Text.IndexOf(TxtFind.Text, StartPosition, SearchType)

            If StartPosition = 0 Or StartPosition < 0 Then
                MessageBox.Show("String: " + TxtFind.Text.ToString() + " not found", "No Matches", MessageBoxButtons.OK, MessageBoxIcon.Asterisk)
                Exit Sub
            End If

            Rftbox.Select(StartPosition, TxtFind.Text.Length)
            Rftbox.ScrollToCaret()
            Rftbox.Focus()
            Btn_FindNext.Enabled = True

        Catch ex As Exception
            MessageBox.Show(ex.Message.ToString(), "Error-CADCIM")
        End Try

    End Sub

    Private Sub Btn_FClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_FClose.Click
        FindPanel.Visible = False
        'FindPanel.Enabled = False
    End Sub

    Private Sub Btn_Replace_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_Replace.Click
        Try
            If Trim(Rftbox.Text) = "" Then Exit Sub
            If Rftbox.SelectedText.Length <> 0 Then
                Rftbox.SelectedText = Txt_Replace.Text
            End If

            Dim StartPosition As Integer
            Dim SearchType As StringComparison

            If Chk_Matchcase.Checked = True Then

                SearchType = StringComparison.Ordinal
            Else

                SearchType = StringComparison.OrdinalIgnoreCase
            End If

            StartPosition = Rftbox.Text.IndexOf(Txt_search.Text, SearchType)

            If StartPosition = 0 Or StartPosition < 0 Then
                MessageBox.Show("String: " + Txt_search.Text.ToString() + " not found", "No Matches", MessageBoxButtons.OK, MessageBoxIcon.Asterisk)
                Exit Sub
            End If

            Rftbox.Select(StartPosition, Txt_search.Text.Length)
            Rftbox.ScrollToCaret()

        Catch ex As Exception
            MessageBox.Show(ex.Message.ToString(), "Error-CADCIM")
        End Try

    End Sub

    Private Sub Btn_RFind_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_RFind.Click
        Try
            If Trim(Rftbox.Text) = "" Then Exit Sub
            Dim StartPosition As Integer = Rftbox.SelectionStart + 2
            Dim SearchType As StringComparison

            If Chk_Matchcase.Checked = True Then
                SearchType = StringComparison.Ordinal
            Else
                SearchType = StringComparison.OrdinalIgnoreCase
            End If

            'StartPosition = Microsoft.VisualBasic.Strings.InStr(StartPosition, mMain.Rftbox.Text, txtSearchTerm.Text, SearchType);
            StartPosition = Rftbox.Text.IndexOf(Txt_search.Text, StartPosition, SearchType)

            If StartPosition = 0 Or StartPosition < 0 Then
                MessageBox.Show("String: " + Txt_search.Text.ToString() + " not found", "No Matches", MessageBoxButtons.OK, MessageBoxIcon.Asterisk)
                Exit Sub
            End If

            Rftbox.Select(StartPosition, Txt_search.Text.Length)
            Rftbox.ScrollToCaret()
            Rftbox.Focus()
            Btn_RF_Next.Enabled = True
        Catch ex As Exception
            MessageBox.Show(ex.Message.ToString(), "Error-CADCIM")
        End Try
    End Sub

    Private Sub Btn_RF_Next_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_RF_Next.Click
        Try
            If Trim(Rftbox.Text) = "" Then Exit Sub
            Dim StartPosition As Integer = Rftbox.SelectionStart + 2
            Dim SearchType As StringComparison

            If Chk_Matchcase.Checked = True Then
                SearchType = StringComparison.Ordinal
            Else
                SearchType = StringComparison.OrdinalIgnoreCase
            End If

            'StartPosition = Microsoft.VisualBasic.Strings.InStr(StartPosition, mMain.Rftbox.Text, txtSearchTerm.Text, SearchType);
            StartPosition = Rftbox.Text.IndexOf(Txt_search.Text, StartPosition, SearchType)

            If StartPosition = 0 Or StartPosition < 0 Then
                MessageBox.Show("String: " + Txt_search.Text.ToString() + " not found", "No Matches", MessageBoxButtons.OK, MessageBoxIcon.Asterisk)
                Exit Sub
            End If

            Rftbox.Select(StartPosition, Txt_search.Text.Length)
            Rftbox.ScrollToCaret()
            Rftbox.Focus()
            Btn_RFind.Enabled = True

        Catch ex As Exception
            MessageBox.Show(ex.Message.ToString(), "Error-CADCIM")
        End Try
    End Sub

    Private Sub Btn_AReplace_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_AReplace.Click
        Try
            If Trim(Rftbox.Text) = "" Then Exit Sub
            Rftbox.Rtf = Rftbox.Rtf.Replace(Txt_search.Text.Trim(), Txt_Replace.Text.Trim())


            Dim StartPosition As Integer
            Dim SearchType As StringComparison

            If Chk_Matchcase.Checked = True Then
                SearchType = StringComparison.Ordinal
            Else
                SearchType = StringComparison.OrdinalIgnoreCase
            End If

            StartPosition = Rftbox.Text.IndexOf(Txt_Replace.Text, SearchType)

            Rftbox.Select(StartPosition, Txt_Replace.Text.Length)
            Rftbox.ScrollToCaret()

        Catch ex As Exception
            MessageBox.Show(ex.Message.ToString(), "Error-CADCIM")
        End Try
    End Sub

    Private Sub Btn_RClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_RClose.Click
        ReplacePanel.Visible = False
    End Sub

    Private Sub tbrOpen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tbrOpen.Click
        OpenMenuItem_Click(Me, New EventArgs)
    End Sub

    Private Sub FileToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FileToolStripMenuItem.Click

    End Sub

    Private Sub ToolStripMenuItem1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)

    End Sub
End Class
