﻿Public Class FrmCustomerDetails
    Dim ObjCust As New Customer
    Dim Bol_Txt As Boolean
    Dim Bol_Int As Boolean


    Private Sub FrmCustomerDetails_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Bol_Txt = False
        Bol_Int = False
    End Sub

    Private Sub BtnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles BtnSave.Click
        With ObjCust
            .Cid = TxtC_ID.Text
            .Fname = TxtLName.Text
            .Lname = TxtLName.Text
            .Add = TxtAdd.Text
            .Telno = Val(TxtTelNo.Text)
            .Email = TxtEmail.Text
        End With
    End Sub

    Public Sub Validate_Data(ByVal Cid As String)
        Dim Chk_I As Integer
        Dim Chk_II As String
        Dim Chk_III As Boolean
        Chk_I = Len(Cid)
        Chk_II = Mid(Cid, 1, 1)
        Chk_III = Val(Mid(Cid, 2, 4))

        If Chk_I <> 4 Or Chk_II <> "C" Or Chk_III <> True Then
            MessageBox.Show("Please enter the valid data. The Customer id should start with letter 'C' " & Chr(13) & _
                            "and followed by three digits.", "CADCIM", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Bol_Txt = True
        End If
    End Sub

    Public Sub Validate_Data(ByVal Telno As Long)
        If Len(Trim(Telno)) < 10 Or Len(Trim(Telno)) > 10 Then
            MessageBox.Show("Please enter the valid data. The Telephone number should be of 10 digits", _
                            "CADCIM", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Bol_Int = True
        End If
    End Sub

    Private Sub BtnGet_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnGet.Click
        With ObjCust
            LblC_ID.Text = .Cid
            LblFName.Text = .Fname
            LblLName.Text = .Lname
            LblAdd.Text = .Add
            LblTelNo.Text = .Telno
            LblEmail.Text = .Email
        End With
    End Sub

    Private Sub BtnChkData_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnChkData.Click
        Try
            Validate_Data(TxtC_ID.Text)
            If Bol_Txt = True Then
                Bol_Txt = False
                TxtC_ID.Clear()
                TxtC_ID.Focus()
                Exit Sub
            End If

            Dim Ctr_I As Long
            If Len(TxtTelNo.Text) = 0 Then
                MessageBox.Show("Please enter the Telephone number")
                Exit Sub
            ElseIf Val(TxtTelNo.Text) <> 0 Then
                Ctr_I = CType(TxtTelNo.Text, Long)
                Validate_Data(Ctr_I)
            End If
            If Bol_Int = True Then

            End If
        Catch ex As Exception
            MessageBox.Show(ex.Message.ToString(), "Error-CADCIM", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
        
    End Sub

    Private Sub TxtTelNo_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles TxtTelNo.KeyPress
        If Asc(e.KeyChar) = 8 Then Exit Sub
        If Asc(e.KeyChar) < 48 Or Asc(e.KeyChar) > 57 Then
            e.KeyChar = ""
            Exit Sub
        End If
    End Sub

    Private Sub BtnClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnClear.Click
        Dim Ctrl As Control
        For Each Ctrl In Me.Controls
            If TypeOf Ctrl Is TextBox Then
                Ctrl.Text = ""
            End If
        Next
        LblC_ID.Text = "C_ID"
        LblFName.Text = "Fname"
        LblLName.Text = "Lname"
        LblAdd.Text = "Add"
        LblTelNo.Text = "TelNo"
        LblEmail.Text = "E-mail"
    End Sub

    Private Sub BtnExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnExit.Click
        End
    End Sub
End Class
