Imports System.Data.SqlClient
Public Class FrmEmpData
    Dim Dr As SqlDataReader
    Dim Da As SqlDataAdapter
    Dim Dc As SqlCommand
    Dim Ds As New DataSet
    Dim Upload_file As String

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If SqlCnn.State = ConnectionState.Open Then SqlCnn.Close()
    End Sub

    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If SqlCnn.State = ConnectionState.Closed Then SqlCnn.Open()
        Btn_Add.Enabled = False
        TxtEmpId.ReadOnly = True
        TxtName.Focus()
        LoadData()
    End Sub

    Public Sub LoadData()
        Dim Dt As DataTable

        Da = New SqlDataAdapter("Select * from country order by country", SqlCnn)
        Dt = New DataTable
        Da.Fill(Dt)
        CmbCountry.DataSource = Dt
        CmbCountry.DisplayMember = "Country"
        CmbCountry.ValueMember = "Country"
        Dt = Nothing
        CmbCountry.SelectedIndex = 0
      
        TxtName.Focus()
        CmbYrs.Items.Add("--Year--")
        CmbMonth.Items.Add("--Month--")
        For I_Ctr As Integer = 0 To 40
            CmbYrs.Items.Add(I_Ctr)
        Next

        For i_ctr As Integer = 0 To 11
            CmbMonth.Items.Add(i_ctr)
        Next
        CmbMonth.SelectedIndex = 0
        CmbYrs.SelectedIndex = 0
    End Sub

    Private Sub DateTimePicker1_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles DateTimePicker1.ValueChanged
        TxtDateB.Text = DateValue(DateTimePicker1.Value)
    End Sub

    Private Sub Btn_Update_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_Update.Click
        FrmEmpReport.Show(Me)
    End Sub

    Private Sub Btn_Exit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_Exit.Click
        End
    End Sub

    Private Sub Btn_Delete_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_Delete.Click
        Dim Str_emp As String
        Str_emp = InputBox("Enter the Emp ID", "Delete employee data")
        If Str_emp = "" Then Exit Sub
        Dc = New SqlCommand("delete from EmpData where Empid='" & Str_emp & "'", SqlCnn)
        Dc.ExecuteNonQuery()
        MessageBox.Show("Record Deleted", "Employee Data")
    End Sub

    Private Sub Btn_Add_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_Add.Click

        Dim Str_sql As String
        If Upload_file = "" Then
            MessageBox.Show("Please upload your photo", "CADCIM - ERROR", MessageBoxButtons.OK)
            Exit Sub
        End If

        Dim EmpId, EmpName, Gender, BirthDate, Resd_Country, Location, Std_Code, Phone, Mobile, Email, Photo, _
        Qualification, Higher_Qual, Specialization, Yr_Exp, Mon_Exp, Industry, Func_Area, Role, _
        KeySkills As SqlParameter

        Str_sql = "INSERT INTO EmpData (EmpId, EmpName, Gender, BirthDate, Resd_Country, Location, Std_Code, Phone, " & _
                "Mobile, Email, Photo, Qualification, Higher_Qual, Specialization,  Yr_Exp, Mon_Exp, Industry, " & _
                "Func_Area, Role, KeySkills) VALUES (@EmpId, @EmpName, @Gender, @BirthDate, @Resd_Country, " & _
                "@Location, @Std_Code, @Phone, @Mobile, @Email, @Photo, @Qualification, @Higher_Qual, @Specialization, " & _
                "@Yr_Exp, @Mon_Exp, @Industry, @Func_Area, @Role, @KeySkills)"

        Dc = New SqlCommand(Str_sql, SqlCnn)

        EmpId = New SqlParameter("@EmpId", SqlDbType.VarChar, 4)
        EmpName = New SqlParameter("@EmpName", SqlDbType.NVarChar, 50)
        Gender = New SqlParameter("@Gender", SqlDbType.VarChar, 6)
        BirthDate = New SqlParameter("@BirthDate", SqlDbType.DateTime)
        Resd_Country = New SqlParameter("@Resd_Country", SqlDbType.VarChar, 80)
        Location = New SqlParameter("@Location", SqlDbType.NVarChar, 80)
        Std_Code = New SqlParameter("@Std_Code", SqlDbType.VarChar, 5)
        Phone = New SqlParameter("@Phone", SqlDbType.VarChar, 10)
        Mobile = New SqlParameter("@Mobile", SqlDbType.VarChar, 10)
        Email = New SqlParameter("@Email", SqlDbType.VarChar, 80)
        Photo = New SqlParameter("@Photo", SqlDbType.VarChar, 200)
        Qualification = New SqlParameter("@Qualification", SqlDbType.NVarChar, 80)
        Higher_Qual = New SqlParameter("@Higher_Qual", SqlDbType.VarChar, 50)
        Specialization = New SqlParameter("@Specialization", SqlDbType.VarChar, 50)
        Yr_Exp = New SqlParameter("@Yr_Exp", SqlDbType.NVarChar, 10)
        Mon_Exp = New SqlParameter("@Mon_Exp", SqlDbType.NVarChar, 10)
        Industry = New SqlParameter("@Industry", SqlDbType.VarChar, 80)
        Func_Area = New SqlParameter("@Func_Area", SqlDbType.VarChar, 80)
        Role = New SqlParameter("@Role", SqlDbType.NVarChar, 80)
        KeySkills = New SqlParameter("@KeySkills", SqlDbType.VarChar, 200)


        EmpId.Value = TxtEmpId.Text
        EmpName.Value = TxtName.Text
        If RbFemale.Checked Then
            Gender.Value = RbFemale.Text
        Else
            Gender.Value = RbMale.Text
        End If
        BirthDate.Value = TxtDateB.Text
        Resd_Country.Value = CmbCountry.Text
        Location.Value = TxtCurrLocation.Text
        Std_Code.Value = TxtCode.Text
        Phone.Value = TxtPhone.Text
        Mobile.Value = TxtMobile.Text
        Email.Value = TxtEmail.Text
        Photo.Value = Upload_file
        Qualification.Value = TxtQualF.Text
        Higher_Qual.Value = TxtHQualf.Text
        Specialization.Value = TxtSpecl.Text
        Yr_Exp.Value = CmbYrs.Text
        Mon_Exp.Value = CmbMonth.Text
        Industry.Value = TxtIndustry.Text
        Func_Area.Value = TxtCfuncArea.Text
        Role.Value = TxtRole.Text
        KeySkills.Value = TxtKeySkills.Text

        Dc.Parameters.Add(EmpId)
        Dc.Parameters.Add(EmpName)
        Dc.Parameters.Add(Gender)
        Dc.Parameters.Add(BirthDate)
        Dc.Parameters.Add(Resd_Country)
        Dc.Parameters.Add(Location)
        Dc.Parameters.Add(Std_Code)
        Dc.Parameters.Add(Phone)
        Dc.Parameters.Add(Mobile)
        Dc.Parameters.Add(Email)
        Dc.Parameters.Add(Photo)
        Dc.Parameters.Add(Qualification)
        Dc.Parameters.Add(Higher_Qual)
        Dc.Parameters.Add(Specialization)
        Dc.Parameters.Add(Yr_Exp)
        Dc.Parameters.Add(Mon_Exp)
        Dc.Parameters.Add(Industry)
        Dc.Parameters.Add(Func_Area)
        Dc.Parameters.Add(Role)
        Dc.Parameters.Add(KeySkills)


        Dc.ExecuteNonQuery()
        MessageBox.Show("Data added", "Employee Data")
        Btn_New.Enabled = True
        Btn_Add.Enabled = False
    End Sub

    Private Sub Btn_New_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_New.Click
        Dim Emp_id As String
        Dim Ctrl As String
        Dim Ctrls As Control

        For Each Ctrls In GroupBox1.Controls
            If TypeOf Ctrls Is TextBox Then
                Ctrls.Text = ""
            End If
        Next

        For Each Ctrls In GroupBox2.Controls
            If TypeOf Ctrls Is TextBox Then
                Ctrls.Text = ""
            End If
        Next

        For Each Ctrls In GroupBox3.Controls
            If TypeOf Ctrls Is TextBox Then
                Ctrls.Text = ""
            End If
        Next
        CmbCountry.SelectedIndex = 0
        CmbCountry.SelectedIndex = 0
        CmbCountry.SelectedIndex = 0
        RbFemale.Checked = False
        RbMale.Checked = False

        Dc = New SqlCommand("Select max(EmpId) from EmpData", SqlCnn)
        Dr = Dc.ExecuteReader
        Dr.Read()
        If Not IsDBNull(Dr(0)) Then
            Ctrl = Val(Mid(Dr(0), 2, 3)) + 1
        Else
            Ctrl = 1
        End If

        Emp_id = ""
        If Len(Ctrl) = 1 Then
            Emp_id = "P" & "00" & Ctrl
        ElseIf Len(Ctrl) = 2 Then
            Emp_id = "P" & "0" & Ctrl
        ElseIf Len(Ctrl) = 3 Then
            Emp_id = "P" & Ctrl
        End If
        TxtEmpId.Text = Emp_id
        TxtEmpId.Enabled = True
        PictureBox1.Image = Nothing
        TxtName.Clear()
        TxtName.Focus()
        Dr.Close()
        LoadData()
        Btn_Add.Enabled = True
        Btn_New.Enabled = False

    End Sub

    Private Sub Btn_Upload_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_Upload.Click
        PictureBox1.Image = Nothing
        OpenFileDialog1.Title = "CADCIM - Open File"
        OpenFileDialog1.DefaultExt = "bmp"
        OpenFileDialog1.Filter = "BMP-Windows Bitmap|*.bmp|JPG-JPEG|*.JPG|GIF-CompuServe|*.GIF|All Files|*.*"
        OpenFileDialog1.FilterIndex = 1
        OpenFileDialog1.FileName = String.Empty
        OpenFileDialog1.ShowDialog()
        Upload_file = OpenFileDialog1.FileName
        If Upload_file = "" Or Upload_file = "OpenFileDialog" Then
            MessageBox.Show("Please upload the your photo", "CADCIM - ERROR", MessageBoxButtons.OK)
            Exit Sub
        End If
        PictureBox1.Load(OpenFileDialog1.FileName)

    End Sub

    Private Sub TxtKeySkills_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TxtKeySkills.TextChanged
        Lbl_Keys.Text = Len(TxtKeySkills.Text)
    End Sub

    Private Sub TxtCode_GotFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles TxtCode.GotFocus
        TxtCode.Clear()
    End Sub

    Private Sub TxtCode_LostFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles TxtCode.LostFocus
        If TxtCode.Text = "" Then
            TxtCode.Text = "Area Code"
        End If
    End Sub

    Private Sub TxtPhone_GotFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles TxtPhone.GotFocus
        TxtPhone.Clear()
    End Sub

    Private Sub TxtPhone_LostFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles TxtPhone.LostFocus
        If TxtPhone.Text = "" Then
            TxtPhone.Text = "Telephone"
        End If
    End Sub

    Private Sub TxtMobile_GotFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles TxtMobile.GotFocus
        TxtMobile.Clear()
    End Sub

    Private Sub TxtMobile_LostFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles TxtMobile.LostFocus
        If TxtMobile.Text = "" Then
            TxtMobile.Text = "Mobile Number"
        End If
    End Sub

    Private Sub TxtName_Validating(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles TxtName.Validating
        If TxtName.Text = "" Then TxtName.Focus()
    End Sub

    Private Sub RbFemale_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles RbFemale.CheckedChanged, RbMale.CheckedChanged
        If RbFemale.Checked = False Then
            If RbMale.Checked = False Then
                RbMale.Focus()
            End If
        End If
    End Sub

    Private Sub Btn_Search_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Btn_Search.Click
        Dim EmpId As String
        Dim Sql_Str As String
        EmpId = InputBox("Enter the Employee ID", "Search employee data")
        If EmpId = "" Then Exit Sub
        Sql_Str = "Select * from EmpData where Empid='" & EmpId & "'"
        Dc = New SqlCommand(Sql_Str, SqlCnn)
        Dr = Dc.ExecuteReader
        If Not Dr.Read() Then
            MessageBox.Show("Employee ID does not exist", "CADCIM - Information", MessageBoxButtons.OK)
            Dr.Close()
            Exit Sub
        End If

        If IsDBNull(Dr(0)) Then
            MessageBox.Show("Employee ID does not exist", "CADCM - Information", MessageBoxButtons.OK)
            Exit Sub
        End If
        TxtEmpId.Text = Dr(0)
        TxtName.Text = Dr(1)
        If Dr(2) = "Male" Then
            RbMale.Checked = True
            RbFemale.Checked = False
        Else
            RbMale.Checked = False
            RbFemale.Checked = True
        End If
        TxtDateB.Text = Dr(3)
        CmbCountry.Text = Dr(4)
        TxtCurrLocation.Text = Dr(5)
        TxtCode.Text = Dr(6)
        TxtPhone.Text = Dr(7)
        TxtMobile.Text = Dr(8)
        TxtEmail.Text = Dr(9)
        PictureBox1.Image = Nothing
        PictureBox1.Load(Dr(10))
        TxtQualF.Text = Dr(11)
        TxtHQualf.Text = Dr(12)
        TxtSpecl.Text = Dr(13)
        CmbYrs.Text = Dr(14)
        CmbMonth.Text = Dr(15)
        TxtIndustry.Text = Dr(16)
        TxtCfuncArea.Text = Dr(17)
        TxtRole.Text = Dr(18)
        TxtKeySkills.Text = Dr(19)
        Dr.Close()
    End Sub
End Class

